(defun (help (info)))
(autoload "new-undo" "undo.ml")
(autoload "time" "time.ml")
(autoload "spell" "spell.ml")
(autoload "incremental-search" "incr-search.ml")
(autoload "reverse-incremental-search" "incr-search.ml")
(autoload "electric-c-mode" "electric-c.ml")
(autoload "electric-lisp-mode" "electric-lisp.ml")
(autoload "electric-mlisp-mode" "electric-lisp.ml")
(autoload "scribe-mode" "scribe.ml")
(autoload "lisp" "process.ml")
(setq quick-redisplay 1)
(setq default-mode-line-format " %[Buffer: %b%*  File: %f  %M (%m)  %p%]")
(setq wrap-long-lines 1)
(setq backup-before-writing 1)
(setq backup-by-copying-when-linked 1)
(bind-to-key "new-undo" "\^X\^U")
(if (= (getenv "TERM") "perq")
    (load "mouse"))
(auto-execute "electric-c-mode" "*.c")
(auto-execute "electric-c-mode" "*.h")
(auto-execute "text-mode" "/tmp/*")
(auto-execute "scribe-mode" "*.mss")
(auto-execute "electric-mlisp-mode" "*.ml")
(auto-execute "electric-lisp-mode" "*.l")
(auto-execute "electric-mlisp-mode" "*.emacs_pro")
