(declare-global inmail outmail mailbox oldbuff ermsg)
(setq outmail (concat (getenv "HOME") "/outgoing"))
(setq mailbox (concat (getenv "HOME") "/mbox"))
(defun
    (quit-mail msgno
	(setq msgno 1)
	(while (> (switch-to-message) -1)
	    (if (> (buffer-size) 1)
		(progn
		    (beginning-of-file)
		    (set-mark)
		    (end-of-file)
		    (append-region-to-buffer inmail)
		    (erase-buffer)
		    (setq msgno (+ msgno 1))
		)
		(setq msgno (+ msgno 1))
	    ))
	(switch-to-buffer inmail)
	(write-current-file)	; put it all back in mailbox.
	(execute-monitor-command "emacs_quit_mail")
	(switch-to-buffer oldbuff)
	(delete-other-windows)
	(novalue)
    )
   (new-mail
       (setq oldbuff (current-buffer-name))
       (setq inmail (concat (getenv "HOME") "/newmail"))
       (execute-monitor-command "emacs_get_mail")
       (if (! (collect-mail))
	   (progn
	       (switch-to-buffer oldbuff)
	       (delete-other-windows)
	       (message "No New Mail")
	       (novalue)
	   )
	   (progn
	       (switch-to-buffer (concat "message " 1))
	       (delete-other-windows)
	       (novalue)
	   ))
   )
   (old-mail
       (setq oldbuff (current-buffer-name))
       (setq inmail (concat (getenv "HOME") "/mbox"))
       (if (! (collect-mail))
	   (progn
	       (switch-to-buffer oldbuff)
	       (delete-other-windows)
	       (message "No Old Mail")
	       (novalue)
	   )
	   (progn
	       (switch-to-buffer (concat "message " 1))
	       (delete-other-windows)
	       (novalue)
	   ))
       (novalue)
   )
   (collect-mail msgcnt
       (switch-to-buffer inmail)
       (read-file inmail)
       (set-mark)
       (setq msgcnt 0)
       (if (<= (buffer-size) 1) 0
	 (progn
           (while (! (eobp))
	       (setq msgcnt (+ 1 msgcnt))
	       (search-forward  "--------------------")
	       (next-line)
	       (beginning-of-line)
	       (delete-region-to-buffer (concat "message " msgcnt))
	   )
	   1))
   )
    (switch-to-message curr-buff
	(setq curr-buff (current-buffer-name))
	(if (error-occured (use-old-buffer (concat "message " msgno)))
	    -1			; < mess 0 or > max. no. of msgs
	    (if (<= (buffer-size) 1)
		(progn		; buffer empty -> msg deleted
		    (use-old-buffer curr-buff)
		    0		; error return
		)
		1)		; successful return
    )   )
    (current-message-number
	(substr (current-buffer-name) -2 2))
    (next-message cc msgno curr-buff
	(setq curr-buff (current-buffer-name))
	(setq msgno (+ (current-message-number) 1))
	(while (= (setq cc (switch-to-message)) 0)
	    (setq msgno (+ 1 msgno))
	)
	(if (= cc -1)
	    (progn 
		(use-old-buffer curr-buff)
		(message "no next message")
	    )))
    (previous-message cc msgno curr-buff
	(setq curr-buff (current-buffer-name))
	(setq msgno (- (current-message-number) 1))
	(while (= (setq cc (switch-to-message)) 0)
	    (setq msgno (- msgno 1))
	)
	(if (= cc -1)
	    (progn 
		(use-old-buffer curr-buff)
		(message "no previous message")
	    )))
    (query-message msgno cc curr-buff
	(setq curr-buff (current-buffer-name))
	(setq msgno (get-tty-string "message number: "))
	(if (= (setq cc (switch-to-message)) 0)
	    (progn
		(switch-to-buffer curr-buff)
		(message "that one got deleted")
		(novalue)
	    )
	    (if (= cc -1)
	      (progn
		(switch-to-buffer curr-buff)
		(message "no such message")
		(novalue)
	      )
	      (novalue)
     )  )   )
    (write-message
        (if (= oldbuff 0)(setq oldbuff (current-buffer-name)))
	(switch-to-buffer "outgoing")
	(setq right-margin 78)
	(erase-buffer)
	(insert-string "TO: ")
	(newline)
	(insert-string "SUBJECT: ")
	(beginning-of-file)
	(end-of-line)
	(novalue)
    )
    (reply-to-message
	(beginning-of-file)
	(search-forward "From:")
	(search-forward "(")
	(set-mark)
	(search-forward ")")
	(backward-character)
	(delete-to-killbuffer)
	(yank-from-killbuffer)
	(split-current-window)
	(write-message)
	(yank-from-killbuffer)
	(next-line)
	(novalue)
    )
    (send-message to subject
	(switch-to-buffer "outgoing")
	(if (< (buffer-size) 17)
	    (error-message "nothing to send")
	    (progn
		(beginning-of-file)
		(search-forward "TO: ")
		(set-mark)
		(end-of-line)
		(setq to (region-to-string))
		(search-forward "SUBJECT: ")
		(set-mark)
		(end-of-line)
		(setq subject (region-to-string))
		(set-mark)
		(beginning-of-file)
		(delete-to-killbuffer)
	        (write-named-file outmail)
		(yank-from-killbuffer)
		(execute-monitor-command
		    (concat "emacs_send_mail " 
			(concat outmail
			    (concat " '"
			        (concat subject 
				    (concat "' " to))))
                )   )
		(switch-to-buffer "Command execution")
		(find-nonexistent-recipients)
		(if (= (buffer-size) 0)
		    (progn 
			(switch-to-buffer "outgoing")
			(message "sent")
		    ))
	    ))
	(novalue)
    )
    (find-nonexistent-recipients
	(end-of-file)
	(set-mark)
	(if (error-occured (search-reverse " cannot be found"))
	    (erase-buffer)	; everyone got it....
	    (progn
		(delete-to-killbuffer)
		(beginning-of-file)
		(replace-string "cannot be found
" "")
    	)   )	
    )
)
(bind-to-key "next-message" (+ 128 'n'))
(bind-to-key "previous-message" (+ 128 'p'))
(bind-to-key "query-message" (+ 128 'm'))
(bind-to-key "write-message" (+ 128 'w'))
(bind-to-key "send-message" (+ 128 's'))
(bind-to-key "erase-buffer" (+ 128 'e'))
(bind-to-key "reply-to-message" (+ 128 'a'))
(bind-to-key "quit-mail" (+ 128 'g'))
