(defun
    
    (c-paren
	(insert-character (last-key-struck))
	(save-excursion
	    (backward-paren)
	    (if (dot-is-visible)
		(sit-for 5)
		(progn
		    (beginning-of-line)
		    (set-mark)
		    (end-of-line)
		    (message (region-to-string)))
	    )
	)
    )

    (c-indent old-dot old-size
        (setq old-dot (+ (dot) 0))
	(setq old-size (buffer-size))
	(save-excursion
	    (previous-line)
	    (re-search-forward "^}")
	    (set-mark)
	    (backward-paren)
	    (beginning-of-line)
	    (exchange-dot-and-mark)
	    (end-of-line)
	    (forward-character)
	    (filter-region "indent -st")
	)
	(goto-character (/ (* (buffer-size) old-dot) old-size))
	(novalue)
    )
    
    (electric-} (if (eolp)
		    (progn
			(delete-white-space)
			(if (! (bolp))
			    (newline-and-indent)
			    (progn
				(delete-previous-character)
				(newline-and-indent)
			    )
			)
			(c-paren)
			(dedent-line)
			(newline-and-indent)
		    )
		    (c-paren)
		)
    )
    
    (electric-{ (if (eolp)
		    (progn
			(insert-string "{")
			(newline-and-indent)
			(indent-line)
		    )
		    (insert-string "{")
		)
    )
    
    (dedent-line (beginning-of-line)
	(to-col (- (current-indent) 4))
	(insert-string ".")
	(delete-white-space)
	(delete-previous-character)
	(end-of-line)
    )
    
    (indent-line (beginning-of-line)
	(to-col (+ (current-indent) 4))
	(insert-string ".")
	(delete-white-space)
	(delete-previous-character)
	(end-of-line)
    )
    
    (electric-semi (insert-string ";")
	(if (eolp) (newline-and-indent))
    )
    
    (skip-spaces (forward-character)
	(while (| (| (= (following-char) ' ')
		      (= (following-char) '	'))
		   (= (following-char) 10))
	    (forward-character)
	)
    )
    
    (electric-* (if (& (eolp) (= (preceding-char) '/'))
		    (progn
			(delete-previous-character)
			(if (! (bolp))
			    (progn
				(delete-white-space)
				(if (bolp) (delete-previous-character))
			    )
			)
			(begin-C-comment)
		    )
		    (insert-string "*")
		)
    )
    
    (electric-/ (if (& (eolp) (= (preceding-char) '*'))
		    (progn
			(delete-previous-character)
			(end-C-comment)
		    )
		    (insert-string "/")
		)
    )
    
    (begin-C-comment (move-to-comment-column)
	(setq left-margin (current-column))
	(setq right-margin 78)
	(setq prefix-string "   ")
	(insert-string "/* ")
    )
    
    (end-C-comment
	(if (!= (preceding-char) ' ') (insert-character ' '))
	(insert-character '*')
	(insert-character '/')
	(setq right-margin 1000)
    )
    
    (high-voltage-on
	(local-bind-to-key "electric-semi" ';')
	(local-bind-to-key "electric-{" '{')
	(local-bind-to-key "electric-}" '}')
	(local-bind-to-key "electric-*" '*')
	(local-bind-to-key "electric-/" '/')
	(local-bind-to-key "high-voltage-off" '')
	(message "high voltage on")
    )
    
    (high-voltage-off
	(local-bind-to-key "self-insert" ';')
	(local-bind-to-key "self-insert" '{')
	(local-bind-to-key "c-paren" '}')
	(local-bind-to-key "self-insert" '*')
	(local-bind-to-key "self-insert" '/')
	(local-bind-to-key "high-voltage-on" '')
	(message "high voltage off")
    )
    
    (electric-c-mode
	(setq mode-string "electric-C")
	(use-syntax-table "C")
	(local-bind-to-key "forward-paren" (+ 128 ')'))
	(local-bind-to-key "backward-paren" (+ 128 '('))
	(local-bind-to-key "begin-C-comment" (+ 128 '`'))
	(local-bind-to-key "c-paren" ')')
	(local-bind-to-key "c-paren" ']')
	(local-bind-to-key "c-paren" '}')
	(local-bind-to-key "end-C-comment" (+ 128 '''))
	(local-bind-to-key "c-indent" (+ 128 'j'))
        (local-bind-to-key "high-voltage-on" '')
	(use-abbrev-table "electric-c")
	(novalue)
    )
)
(use-syntax-table "C")
(modify-syntax-entry "()   (")
(modify-syntax-entry ")(   )")
(modify-syntax-entry "(}   {")
(modify-syntax-entry "){   }")
(modify-syntax-entry "(]   [")
(modify-syntax-entry ")[   ]")
(modify-syntax-entry """    '")
(modify-syntax-entry """    """)
(modify-syntax-entry "\\    \\")
(modify-syntax-entry "w    _")
