(declare-buffer-specific extra-space-list)
(setq-default extra-space-list ".!?:")
(defun
    (justify-paragraph
	(error-occured
	    (save-excursion
		(beginning-of-line)
		(while (& (! (bobp))
			   (! (eolp))
			   (!= (following-char) '@'))
		    (progn (previous-line)(beginning-of-line)))
		(if (| (eolp) (= (following-char) '@'))
		    (progn (next-line)(beginning-of-line)))
		(if (& (! (eolp))
			(!= (following-char) '@'))
		    (progn last-col c-col
			(delete-white-space)
			(to-col left-margin)
			(while (progn
				   (end-of-line)
				   (if (! (eobp)) (forward-character))
				   (& (! (eolp))
				       (!= (following-char) '@')))
			    (delete-previous-character)
			    (delete-white-space)
			    (if (save-excursion
				    (backward-character)
				    (looking-at
					(concat "[" extra-space-list "]")))
				(insert-string "  ")
				(insert-string " "))
			)
			(if (bolp) (backward-character))
			(setq c-col (current-column))
			(while (progn
				   (setq last-col c-col)
				   (insert-character '!')
				   (delete-previous-character)
				   (beginning-of-line)
				   (if (= (following-char) '@')
				       (insert-character ' '))
				   (end-of-line)
				   (setq c-col (current-column))
				   (< c-col last-col))
			    (novalue))
		    )
		)
	    )
	    (message "Done!")
	    (novalue)
	)
    )
)
