;  This autoloaded file implements the "i" command of mhe
(defun 
    (&mh-inc old-folder
	(&mh-save-killbuffer)
	(setq old-folder mh-folder)
	(if (!= mh-folder "inbox")
	    (save-window-excursion  ffl
		(setq ffl (get-folder-name "inc into" "inbox" 1))
		(&mh-read-folder ffl "" t-buffer-filename ffl)
	    )
	)
	; mh-folder is inbox, but not visible if we weren't there before 'i'
	(message "Checking for new mail...") (sit-for 0)
	(send-to-shell (concat mh-remote mh-progs "/inc +" mh-folder mh-width))
	(temp-use-buffer "mh-temp")
	(beginning-of-file)
	(if (looking-at "^Incorporating")
	    (progn 
		   (&mh-pop-to-buffer (concat "+" old-folder))
		   (switch-to-buffer (concat "+" mh-folder))
		   (end-of-file)
		   (&mh-add-inc-headers)
		   (&mh-unmark-all-headers 0)
		   (beginning-of-line)
		   (goto-character (+ (dot) mh-msgnum-cols))
		   (delete-next-character)
		   (insert-character '+')
		   (beginning-of-line)
		   (setq mh-direction 1)
		   (temp-use-buffer "mh-temp") (erase-buffer)
		   (insert-string global-mode-string)
		   (beginning-of-file)
		   (error-occured (search-forward " Mail")
		       (region-around-match 0)
		       (erase-region)
		       (set-mark) (beginning-of-file)
		       (setq global-mode-string (region-to-string))
		   )
		   (temp-use-buffer (concat "+" mh-folder))
		   (message "...done.") (sit-for 0)
	    )
	    ;  Undo folder switching -- old-folder is still visible.
	    (progn 
		   (setq mh-folder old-folder)
		   (&mh-pop-to-buffer (concat "+" mh-folder))
		   (message "No new mail.")
	    )
	)
	(&mh-restore-killbuffer)
    )
)
